import { Block, BlockInventoryComponent, ItemStack, system, world } from "@minecraft/server";
import { SMELTABLE_ITEMS_XP_REWARD } from "../registry/SmeltableItems";
const FURNACE_CACHE = new Map();
const FURNACES = ["minecraft:furnace", "minecraft:blast_furnace", "minecraft:smoker"];
export class FurnaceBlock {
  constructor() {
    this.#onPlayerInteractWithFurnace();
  }
  #onPlayerInteractWithFurnace() {
    system.run(() => {
      world.afterEvents.playerInteractWithBlock.subscribe(({  block, isFirstEvent }) => {
        if (!isFirstEvent) return;
        if (FURNACES.includes(block.typeId)) return;
        const outputSlot = 2;
        system.runInterval(() => {
          if (!block.isValid()) return;
          const inventory = block.getComponent(BlockInventoryComponent.componentId);
          const container = inventory?.container;
          const stack = container?.getItem(outputSlot);
          if (!stack) {
            if (FURNACE_CACHE.has(block)) {
              const lastStack = FURNACE_CACHE.get(block);
              if (!this.#isSmeltableItem(lastStack)) return;
              const xpRewardCount = lastStack.amount * SMELTABLE_ITEMS_XP_REWARD[lastStack.typeId];
              for (let i = 0; i <= xpRewardCount; i++) {
                block.dimension.spawnEntity("minecraft:xp_orb", block.bottomCenter());
              }
              FURNACE_CACHE.delete(block);
            }
          } else {
            if (!this.#isSmeltableItem(stack)) return;
            FURNACE_CACHE.set(block, stack);
          }
        }, 5);
      });
    });
  }
  #isSmeltableItem(stack) {
    return SMELTABLE_ITEMS_XP_REWARD.hasOwnProperty(stack.typeId);
  }
}
new FurnaceBlock();